package cn.com.tuia.advert.service;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.tuia.advert.model.AdvOrientationDto;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;

import java.util.List;

/**
 * 互动直投、视频广告发券服务接口
 *
 * @author peanut.huang
 * @date 2019/1/28
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface InteractiveDirectService {


    /**
     * <h3>互动直投、视频广告发券</h3>
     * 已知使用方： <br/>
     *  1. tuia-open-web的sdk的互动直投 <br/>
     *  2. tuia-activity-web的互动直投 <br/>
     *
     * @return
     */
    ObtainAdvertRsp interactionDirectAdvert(ObtainAdvertReq req);

    /**
     * <h3>互动直投发券</h3>
     * 带有券次序功能
     * @param req
     * @return
     */
    ObtainAdvertRsp loadAdvertWithCustomOrder(ObtainAdvertReq req);

}
