package cn.com.tuia.advert.enums;


import com.google.common.collect.Maps;

import java.util.Map;
import java.util.Optional;

/**
 * 设备价格区间枚举
 */
public enum PriceLevelEnum {


    ONE(1,"0-599"),

    TWO(2,"600-1099"),

    THREE(3,"1100-1699"),

    FOUR(4,"1700-2699"),

    FIVE(5,"2700-4499"),

    SIX(6,"4500+"),

    SEVEN(7,"其他");


    private Integer code;

    private String name;

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    PriceLevelEnum(Integer code, String name){
        this.code=code;
        this.name=name;
    }

    private static Map<Integer, String> enumMap = Maps.newHashMap();

    static{
        for (PriceLevelEnum priceLevelEnum : PriceLevelEnum.values()) {
            enumMap.put(priceLevelEnum.getCode(),priceLevelEnum.getName());
        }
    }

    public static String getPriceLevelCode(Integer code){
        return Optional.ofNullable(enumMap.get(code)).orElse("");
    }
}
