package cn.com.tuia.advert.model.messageDto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * ClassName:广告通知消息体 &lt;br/&gt;
 * Function:  ADD FUNCTION. &lt;br/&gt;
 * Date:     20190808  &lt;br/&gt;
 *
 * @author chencheng
 * @see
 * @since JDK 1.8
 */
public class AdvertMsg implements Serializable {

    private static final long serialVersionUID = -3758234893386283987L;

    /** 更新所有广告内存. */
    public static final int UPDATE_ALL    = 0;

    /** 更新特定列表中的广告内存. */
    public static final int UPDATE_TRAGET = 1;

    /** 0：更新所有广告内存，1：更新特定列表中的广告内存. */
    private Integer         type;

    /** The ids. */
    private List<Long> ids;

    /** 广告类型，1-互动、2-展示、3-激励 */
    private Integer advertType;


    /**方法名*/
    private String methodName;

    private Map<String,Boolean> advertPkgPutFlagCache;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public AdvertMsg() {
    }

    public AdvertMsg(Integer type) {
        this.type = type;
    }

    public Map<String, Boolean> getAdvertPkgPutFlagCache() {
        return advertPkgPutFlagCache;
    }

    public void setAdvertPkgPutFlagCache(Map<String, Boolean> advertPkgPutFlagCache) {
        this.advertPkgPutFlagCache = advertPkgPutFlagCache;
    }

    public AdvertMsg(Integer type, List<Long> ids, Integer advertType, String methodName) {
        super();
        this.type = type;
        this.ids = ids;
        this.methodName=methodName;
        this.advertType = advertType;
    }
}
