package cn.com.tuia.advert.enums;

import java.util.Map;
import java.util.Optional;

import com.google.common.collect.Maps;

/**
 * 
 * ClassName: AbnormalMonitoringRuleTypeEnum <br/>
 * Function: 广告异常监控-监控规则枚举. <br/>
 * 监控规则：1-昨日同时段累计值环比上下波动，2-昨日同时段累计值环比上升，3-昨日同时段累计值环比下降，4-今日累计高于，5-今日累计低于
 * date: 2019年3月26日 下午6:54:16 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AbnormalMonitoringRuleTypeEnum {
    /** 昨日同时段累计值环比上下波动 */
    YESTERDAY_RATIO_FLOAT(1,2,"昨日同时段累计值环比上下波动"),

    /** 昨日同时段累计值环比上升 */
    YESTERDAY_RATIO_UP(2,2, "昨日同时段累计值环比上升"),

    /** 昨日同时段累计值环比下降*/
    YESTERDAY_RATIO_DOWN(3,2, "昨日同时段累计值环比下降"),

    /** 今日累计高于 */
    TODAY_SUM_ABOVE(4,1, "今日累计高于"),

    /** 今日累计低于 */
    TODAY_SUM_BELOW(5,1, "今日累计低于"),

    /** 注册pv低于 */
    LOAD_PV_BELOW(6,3, "注册pv低于");

    private String desc;

    private Integer code;

    /** 数据处理方式
     * 1-当日累计，2-今日与昨日时段环比，3-半小时数据
     */
    private Integer dataMethod;

    AbnormalMonitoringRuleTypeEnum(Integer code, Integer dataMethod, String desc) {
        this.desc = desc;
        this.dataMethod = dataMethod;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public Integer getDataMethod() {
        return dataMethod;
    }

    private static Map<Integer, AbnormalMonitoringRuleTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AbnormalMonitoringRuleTypeEnum it : AbnormalMonitoringRuleTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AbnormalMonitoringRuleTypeEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    public static Integer getDataMethodByCode(Integer code) {
        return Optional.ofNullable(enumMap.get(code)).map(AbnormalMonitoringRuleTypeEnum::getDataMethod).orElse(0);

    }
}
