package cn.com.tuia.advert.enums;

//广告冷启动测试计划状态枚举
public enum AdZeroStartTestStatusEnum {
    //测试状态：0-排队中，1-测试中，2-测试完成，3-已过期，4-人工暂停
    WAITING(0, "排队中"),
    RUNING(1, "测试中"),
    FINISH(2, "测试完成"),
    TIMEOUT(3, "已过期"),
    STOP(4, "人工停止");


    /**
     * 代码
     */
    private Integer code;
    /**
     * 描述
     */
    private String desc;

    AdZeroStartTestStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AdZeroStartTestStatusEnum getByCode(int code) {
        for (AdZeroStartTestStatusEnum enumVal : AdZeroStartTestStatusEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
