package cn.com.tuia.advert.enums;


import com.google.common.collect.Lists;

import java.util.List;

/**
 * 
 * ClassName: AccountMainTypeEnum <br/>
 * Function: 账户主体类型. <br/>
 * date: 2019年06月28日 下午8:18:08 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AccountMainTypeEnum {

    HZ_TUIA_TYPE(1,"杭州推啊"),

    HOERGOS_TUIA_TYPE(2,"霍尔果斯推啊"),

    HUO_CHENG_TUIA_TYPE(3,"霍城兑捷"),

    HUO_CHENG_DUI_TUI_TYPE(4,"霍尔果斯兑推")
    ;


    /** 代码 */
    private Integer code;
    /** 描述 */
    private String desc;

    private AccountMainTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static AccountMainTypeEnum getByCode(Integer code){
        for(AccountMainTypeEnum enumVal : AccountMainTypeEnum.values()){
            if(code == enumVal.getCode()){
                return enumVal;
            }
        }
        return null;
    }

    /**
     * 所有主体类型
     * @return
     */
    public static List<Integer> listAllMainTypes(){
        List<Integer> all = Lists.newArrayList();
        for(AccountMainTypeEnum enumVal : AccountMainTypeEnum.values()){
            all.add(enumVal.getCode());
        }
        return all;
    }
    /**
     * 返回老主体(杭推+霍推)类型
     * @return
     */
    public static List<Integer> getOldMainTypes(){
        return Lists.newArrayList(HZ_TUIA_TYPE.getCode(),HOERGOS_TUIA_TYPE.getCode());
    }
    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
