package cn.com.tuia.advert.enums;


/**
 *  广告计费方式
 */
public enum ChargeTypeEnum {
    /** CPC. */
    TYPE_CPC(1,"CPC"),

    /**
     * CPA 这里其实用的是ocpc并不是真正的cpa
     */
    TYPE_CPA(2,"CPA"),

    /**
     * NEW-CPA (h这里才是真正的cps)
     */
    TYPE_NEW_CPA(3,"NEW-CPA"),

    TYPE_CPM(4, "CPM");

    ;


    /** 代码 */
    private int code;
    /** 描述 */
    private String desc;

    private ChargeTypeEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static ChargeTypeEnum getByCode(int code){
        for(ChargeTypeEnum enumVal : ChargeTypeEnum.values()){
            if(code == enumVal.getCode()){
                return enumVal;
            }
        }
        return null;
    }
    
    public static String getDescByCode(int code){
        for(ChargeTypeEnum enumVal : ChargeTypeEnum.values()){
            if(code == enumVal.getCode()){
                return enumVal.getDesc();
            }
        }
        return null;
    }

    public static ChargeTypeEnum getByDesc(String desc){
        for(ChargeTypeEnum enumVal : ChargeTypeEnum.values()){
            if(desc.equals(enumVal.getDesc())){
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
