package cn.com.tuia.advert.model;

import cn.com.duiba.tuia.algo.engine.api.req.v4.AlgoExecuteReq;
import cn.com.tuia.advert.enums.ChargeTypeEnum;

/**
 * @author fanjia
 * @date 2022年01月14日 上午8:52
 */
public class AdxObtainAdvertReq extends ObtainAdvertReq {
    /**
     * adx-web系统携带下来的一些透传参数
     * 1.主要作用是adx-web那边处理好和algo算法系统交互参数
     * 2.adx定向计划过滤参数也在这 ideaUnitDTOList
     * 3.一些需要adx-engine传递的给algo的参数 比如 IdeaUnitDTO里的maxPrice价格
     *
     * @author fanjia
     * @date 2021/12/27 下午12:40
     */
    private AlgoExecuteReq algoExecuteReq;

    /**
     * 外部dspId
     */
    private Integer outDspId;

    /**
     * 计费类型 {@link ChargeTypeEnum}
     */
    private int chargeType;

    public int getChargeType() {
        return chargeType;
    }

    public void setChargeType(int chargeType) {
        this.chargeType = chargeType;
    }

    public Integer getOutDspId() {
        return outDspId;
    }

    public void setOutDspId(Integer outDspId) {
        this.outDspId = outDspId;
    }

    public AlgoExecuteReq getAlgoExecuteReq() {
        return algoExecuteReq;
    }

    public void setAlgoExecuteReq(AlgoExecuteReq algoExecuteReq) {
        this.algoExecuteReq = algoExecuteReq;
    }
}
