package cn.com.tuia.advert.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author fanjia
 * @date 2021年08月26日 上午11:27
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AdvertAppInfoDto implements Serializable {

    private static final long serialVersionUID = 8869330828677998482L;
    /**
     * 应用信息需求-应用名称
     */
    private String appInfoName;
    /**
     * 应用信息需求-应用版本
     */
    private String appInfoVersion;
    /**
     * '应用信息需求-应用开发者
     */
    private String appInfoDeveloper;
    /**
     * 应用信息需求-应用的包体大小
     */
    private String appInfoPkgSize;
    /**
     * 应用信息需求-应用权限H5链接
     */
    private String appInfoPermissionUrl;
    /**
     * 应用信息需求-应用隐私政策H5链接
     */
    private String appInfoPrivacyUrl;

}
