package cn.com.tuia.advert.enums;

import java.util.Objects;

/**
 * 百奇微信流量屏蔽状态枚举
 *
 * @author zhangbaiqiang
 * @date 2020/8/24
 */
public enum WxFlowBlockStatusEnum {

    BLOCK(1, "屏蔽"),
    RELEASE(2, "释放");

    private Integer type;
    private String desc;

    WxFlowBlockStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 是否是屏蔽状态
     */
    public static boolean isBlock(Integer status) {
        return Objects.equals(BLOCK.type, status);
    }

    /**
     * 是否是释放状态
     */
    public static boolean isRelease(Integer status) {
        return Objects.equals(RELEASE.type, status);
    }
}
