package cn.com.tuia.advert.model;

import java.io.Serializable;

/**
 * 查询之前请求的广告优惠券
 * 
 * @author: sunjiangrong
 * @version:
 */
public class QueryAdvertReq implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 广告位ID */
    private Long              slotId;

    /** 兑吧订单ID */
    private String            orderId;

    /** 用户id */
    private Long              consumerId;

    /** 展示类型 0：弹层;1：详情 */
    private Integer           showType;

    public Integer getShowType() {
        return showType;
    }

    public void setShowType(Integer showType) {
        this.showType = showType;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * @return the consumerId
     */
    public Long getConsumerId() {
        return consumerId;
    }

    /**
     * @param consumerId the consumerId to set
     */
    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    /**
     * 特殊日志格式，不要删除.
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" [orderId ");
        builder.append(orderId);
        builder.append("] [consumerId ");
        builder.append(consumerId);
        builder.append("] [slotId ");
        builder.append(slotId);
        builder.append("]");
        return builder.toString();
    }
}
