/**
 * Project Name:engine-common File Name:CacheKeyConstant.java Package Name:cn.com.duiba.tuia.cache
 * Date:2016年7月19日下午2:31:11 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.tuia.advert.cache;

/**
 * ClassName:CacheKeyConstant <br/>
 * Date: 2016年7月19日 下午2:31:11 <br/>
 * 
 * @author sunjiangrong
 * @version
 * @since JDK 1.6
 * @see
 */
public class CacheKeyConstant {

    private static String      prefix;

    /** app key */
    public static final String APP                       = "-APP3-";
    /** 有效的广告id列表 key */
    public static final String VALID_ADVERT_IDS          = "-VALID-ADVERT-IDS";
    /** 有效广告的限流APP列表 key */
    public static final String VALID_ADVERT_LIMITING_APPS = "-VALID-ADVERT-LIMITING-APPS-";
    /** 广告id key */
    public static final String ADVERT                    = "-ADVERT-DETAIL-";

    /** 优惠券大字段key */
    public static final String ADVERT_COUPON_BIGFIELD    = "-ADVERT-COUPON-";

    /** 广告计划大字段key */
    public static final String ADVERT_PLAN_BIGFIELD      = "-ADVERT-PLAN-";

    /** 发出的广告订单 key */
    public static final String ADVERTORDER               = "-ADVERTORDER3-";
    /** 用于计算广告统计数据的队列 */
    public static final String NEW_REQ_REDIS4            = "-REQ-LIST4";
    /** 用于计算广告统计数据的队列 */
    public static final String NEW_REQ_REDIS5            = "-REQ-LIST5";
    /** 用于扣减库存以及计费任务的队列 */
    public static final String NEW_REQ_REDIS3            = "-REQ-LIST3";

    /** 统计数据队列切换开关 */
    public static final String REQ_LIST_FLAG             = "-REQ-LIST-FLAG";

    /** 系统配置项：同一活动领取限制. */
    public static final String ACTIVITY_RECEIVE_COUNT    = "activity.receive.count";

    /** 获取券码时分布式锁 */
    public static final String REDIS_LOCK                = "-LOCK-";

    /** The PLAN PERIOD KEY. */
    public static final String PLAN_PERIOD               = "-PERIOD-";
    
    /** The PLAN PERIOD Status KEY. */
    public static final String ADVERT_PLAN_PERIOD_STATUS  = "-ADVERT-PERIOD-STATUS-";

    public static final String ACTIVITY                  = "-ACTIVITY-";

    public static final String DEVACTIVITY               = "-DEVACTIVITY-";

    public static final String CONSUMER                  = "-CONSUMER-";

    /** 用户每天点击计数key. */
    public static final String CONSUMER_CLICK_COUNT      = "-CONSUMER-CLICK-COUNT-";

    /** 用户有效点击之后5分钟内无效标识key. */
    public static final String CONSUMER_CLICK_SHIELD     = "-CONSUMER-CLICK-SHIELD-";

    /** 屏蔽策略标识. */
    public static final String STRATEGY_KEY              = "-TUIA-MEDIA-STRATEGY-";

    /** A/B Test流量分配策略标识. */
    public static final String SHUNT_CONFIG_KEY          = "-SHUNT-CONFIG-";

    /** 轮询方式推荐广告的上次推荐结果tagId. */
    public static final String RECOMMEND_LAST_TAG        = "-RECOMMEND-LAST-TAG-";

    /** 新广告发出的数量. */
    public static final String NEW_ADVERT_COUNT          = "-NEW-ADVERT-COUNT-2-";

    /** 老广告关联. */
    public static final String OLD_ADVERT_RELATION       = "-OLD-ADVERT-RELATION-";

    /** 应用白名单. */
    public static final String APP_WHITE_LIST            = "-APP-WHITE-LIST-";

    /** 用户领取的广告ID列表缓存标识. */
    public static final String RECEIVE_ADVERT_IDS        = "-RECEIVE-ADVERT-IDS-";

    /** 广告定向媒体缓存标识. */
    public static final String ADVERT_TARGET_APPS        = "-ADVERT-TARGET-APPS-";

    /** 广告素材 key. */
    public static final String ADVERT_MATERIAL           = "-ADVERT-MATERIALT-IDS-";

    /** 素材基于媒体曝光次数. */
    public static final String MATERIAL_PUT_APPS_COUNT   = "-ADVERT-PUT-APPS-COUNT-";

    /** 广告位包含的素材及素材状态. */
    public static final String ADVERT_APP_MATERIALS_INFO = "-ADVERT-APP-MATERIALS-INFO-";

    /** 素材(在媒体维度上传)的新老状态. */
    public static final String MATERIALS_APP_STATUS      = "-MATERIALS-APP-STATUS-";

    /** 广告投放地域. */
    public static final String ADVERT_REGION_IDS         = "-ADVERT-REGION-IDS-";

    /** 广告计划. */
    public static final String ADVERT_PLAN               = "-ADVERT-PLAN-";

    /** 广告优惠券. */
    public static final String ADVERT_COUPON             = "-ADVERT-COUPON-";

    /** 根据优惠券批次最晚失效时间的缓存标识. */
    public static final String COUPON_LATEST_ENDVALID    = "-COUPON-LATEST-ENDVALID-";

    /** 根据活动ID和type获取商业活动. */
    public static final String BUSINESS_ACTIVITY         = "-BUSINESS-ACTIVITY-";

    /** 根据活动ID和type获取商业活动下的活动白名单. */
    public static final String BUSINESS_ACTIVITY_ADVERT  = "-BUSINESS-ACTIVITY-ADVERT";
    
    /** 用户基于app广告投放次数. */
    public static final String CONSUMER_APP_JOIN_NUM  = "-JOIN-NUM-";

    /**
     * The Constructor.
     */
    private CacheKeyConstant() {

    }

    public static String getPrefix() {
        return prefix;
    }

    public static void setPrefix(String prefixStr) {
        prefix = prefixStr;
    }
}
