/**
 * 文件名： MemcachedKeyTool.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月8日 上午11:17:51
 */
package cn.com.tuia.advert.cache;

/**
 * 缓存标识.
 *
 * @author: leiliang
 * @version:
 */
public class CachedKeyUtils {

    /**
     * The Constructor.
     */
    private CachedKeyUtils() {

    }

    /**
     * 获取用户领取的广告ID列表缓存标识.
     *
     * @param curDate 当天(格式：yyyy-MM-dd)
     * @param consumerId 用户ID
     * @return the recive advert ids key
     */
    public static String getReciveAdvertIdsKey(String curDate, Long consumerId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.RECEIVE_ADVERT_IDS + curDate + consumerId;
    }

    /**
     * 获取应用白名单缓存标识.
     *
     * @param appId 应用id
     * @return the recive advert ids key
     */
    public static String getAppWhiteListKey(Long appId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.APP_WHITE_LIST + appId;
    }

    /**
     * 获取老广告关联缓存标识.
     *
     * @param newAdvertId the new advert id
     * @return the recive advert ids key
     */
    public static String getOldAdvertRelationKey(Long newAdvertId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.OLD_ADVERT_RELATION + newAdvertId;
    }

    /**
     * 获取广告定向媒体缓存标识.
     *
     * @param advertId the advert id
     * @return the recive advert ids key
     */
    public static String getAdvertTargetAppKey(Long advertId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.ADVERT_TARGET_APPS + advertId;
    }

    /**
     * 获取APP缓存标识.
     *
     * @param appId the app id
     * @return the recive advert ids key
     */
    public static String getAppKey(Long appId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.APP + appId;
    }

    /**
     * 获取广告缓存标识.
     *
     * @param advertId the advert id
     * @return the recive advert ids key
     */
    public static String getAdvertKey(Long advertId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.ADVERT + advertId;
    }

    /**
     * 获取活动白名单缓存标识.
     *
     * @param activityId the activity id
     * @param type the type
     * @return the recive advert ids key
     */
    public static String getActivityWhiteListKey(Long activityId, Integer type) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.ACTIVITY + activityId + "-" + type;
    }

    /**
     * 获取有效广告Id列表缓存标识.
     *
     * @return the activity white list key
     */
    public static String getValidAdvertIdsKey() {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.VALID_ADVERT_IDS;
    }

    /**
     * 获取有效广告限流的APP列表
     * @param advertId
     * @return
     */
    public static String getValidAdvertLimitingAppsKey(Long advertId,String currentDay) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.VALID_ADVERT_LIMITING_APPS + currentDay + "-" + advertId;
    }

    /**
     * 获取兑吧活动缓存标识.
     *
     * @param devActivityId the dev activity id
     * @return the activity white list key
     */
    public static String getDevActivityIdKey(Long devActivityId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.DEVACTIVITY + devActivityId;
    }

    /**
     * 得到流程策略缓存标识.
     *
     * @param curDate the cur date
     * @param shuntId the shunt id
     * @return the dev activity id key
     */
    public static String getShuntConfigKey(String curDate, Long shuntId) {
        return CacheKeyConstant.getPrefix() + curDate + CacheKeyConstant.SHUNT_CONFIG_KEY + shuntId;
    }

    /**
     * 得到上次轮询推荐的标签缓存标识.
     *
     * @param curDate the cur date
     * @param appId the app id
     * @param activityId the activity id
     * @return the shunt config key
     */
    public static String getRecommendLastTagIdKey(String curDate, Long appId, Long activityId) {
        return CacheKeyConstant.getPrefix() + curDate + CacheKeyConstant.RECOMMEND_LAST_TAG + appId + activityId;
    }

    /**
     * 获取新广告发券量缓存标识.
     *
     * @param curDate the cur date
     * @param advertId the advert id
     * @return the new advert count key
     */
    public static String getNewAdvertCountKey(String curDate, Long advertId) {
        return CacheKeyConstant.getPrefix() + curDate + CacheKeyConstant.NEW_ADVERT_COUNT + advertId;
    }

    /**
     * 获取广告素材缓存标识.
     *
     * @param materialId the material id
     * @return the AdvertMaterialIdKey
     */
    public static String getAdvertMaterialKey(Long materialId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.ADVERT_MATERIAL + materialId;
    }

    /**
     * 获取素材基于app的发放次数.
     *
     * @param appId the app id
     * @param materialId the material id
     * @return the new advert count key
     */
    public static String getAdvertMaterialPutAppCountKey(Long appId, Long materialId) {
        return CacheKeyConstant.getPrefix() + appId + CacheKeyConstant.MATERIAL_PUT_APPS_COUNT + materialId;
    }

    /**
     * 获取广告媒体维度下的素材列表缓存key.
     *
     * @param advertId the advert id
     * @param appId the app id
     * @return the new advert count key
     */
    public static String getAdvertAppMaterialsInfoKey(Long advertId, Long appId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.ADVERT_APP_MATERIALS_INFO + advertId + "-" + appId;
    }

    /**
     * 得到素材(在媒体维度)的新老状态key.
     *
     * @param materialId the material id
     * @param appId the app id
     * @return the new old status materials key
     */
    public static String getNewOldStatusMaterialsKey(Long materialId, Long appId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.MATERIALS_APP_STATUS + materialId + "-" + appId;
    }

    /**
     * 得到广告投放地域缓存key.
     *
     * @param advertId the advert id
     * @return the advert region key
     */
    public static String getAdvertRegionKey(Long advertId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.ADVERT_REGION_IDS + advertId;
    }

    /**
     * 得到广告计划缓存key.
     *
     * @param advertId the advert id
     * @return the advert plan key
     */
    public static String getAdvertPlanKey(Long advertId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.ADVERT_PLAN + advertId;
    }

    /**
     * 得到广告优惠券缓存key.
     *
     * @param advertId the advert id
     * @return the advert coupon key
     */
    public static String getAdvertCouponKey(Long advertId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.ADVERT_COUPON + advertId;
    }

    /**
     * 获取优惠券批次最晚失效时间缓存 key.
     *
     * @param advertId the advert id
     * @param latestEndValid the latest end valid
     * @return the coupon latest end valid key
     */
    public static String getCouponLatestEndValidKey(Long advertId) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.COUPON_LATEST_ENDVALID + advertId;
    }
    
    
    /**
     * 获取商业活动白名单缓存 key.
     *
     * @param activityId the activity id
     * @param type the latest activity type
     */
    public static String getBusinessActivityWhiteListKey(Long activityId, Integer type) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.BUSINESS_ACTIVITY_ADVERT + activityId + "-" + type;
    }
    
    /**
     * 获取商业活动缓存 key.
     *
     * @param activityId the activity id
     * @param type the latest activity type
     */
    public static String getBusinessActivityKey(Long activityId, Integer type) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.BUSINESS_ACTIVITY + activityId + "-" + type;
    }
    
    /**
     * 获取商业活动缓存 key.
     *
     * @param consumerId the consumer id
     * @param appId the latest app  id
     */
    public static String getConsumerAppJoinNum(Long appId, Long consumerId,String date) {
        return CacheKeyConstant.getPrefix() + CacheKeyConstant.CONSUMER_APP_JOIN_NUM + appId + "-" + consumerId + "-" + date;
    }

}
