/**
 * 文件名： QueryAdvertRsp.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月27日 下午10:33:41
 */
package cn.com.tuia.advert.model;

import java.io.Serializable;

/**
 * 广告查询接口返回结果 <br/>
 * <功能详细描述>
 * 
 * @author: sunjiangrong
 * @创建时间: 2016年4月27日 下午10:33:41
 * @version:
 */
public class QueryAdvertRsp implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** The result. */
    private boolean           result;

    /** 广告ID. */
    private long              advertId;

    /** 广告所属广告主名称. */
    private String            advertiserName;

    /** 优惠券描述，即详情文案. */
    private String            couponRemark;

    /** 详情图的url地址. */
    private String            bannerPngUrl;

    /** 缩略图的url地址. */
    private String            thumbnailPngUrl;

    /** 券的标题. */
    private String            title;

    /** 券的副标题. */
    private String            viceTitle;

    /** 优惠券有效期的开始时间. */
    private String            startValid;

    /** 优惠券有效期的结束时间. */
    private String            endValid;

    /** 推广网址. */
    private String            promoteUrl;

    /** 对特殊应用隐藏使用按钮(0：否，1：是). */
    private int               specialHide;

    /** 该优惠券的价格(分). */
    private long              couponPrice;

    /** 优惠券类型：1-链接券；2-可重复券；3-普通券. */
    private int               couponType;

    /** 是否为微信券(0：否，1：是) ,只有couponType=2 or couponType=3时有效. */
    private int               isWeixin;

    /** 券码. */
    private String            codeContent;

    /** 券密码. */
    private String            codePasswd;

    /** 按钮文案 */
    private String            buttonText;

    /** 广告位ID */
    private Long              slotId;

    /** 素材ID 确认展示的素材 */
    private Long              materialId;

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    /**
     * specialHide.
     *
     * @return the specialHide
     * @since JDK 1.7
     */
    public int getSpecialHide() {
        return specialHide;
    }

    /**
     * specialHide.
     *
     * @param specialHide the specialHide to set
     * @since JDK 1.7
     */
    public void setSpecialHide(int specialHide) {
        this.specialHide = specialHide;
    }

    /**
     * isWeixin.
     *
     * @return the isWeixin
     * @since JDK 1.7
     */
    public int getIsWeixin() {
        return isWeixin;
    }

    /**
     * isWeixin.
     *
     * @param isWeixin the isWeixin to set
     * @since JDK 1.7
     */
    public void setIsWeixin(int isWeixin) {
        this.isWeixin = isWeixin;
    }

    /**
     * Checks if is result.
     *
     * @return the result
     */
    public boolean isResult() {
        return result;
    }

    /**
     * Sets the result.
     *
     * @param result the result to set
     */
    public void setResult(boolean result) {
        this.result = result;
    }

    /**
     * Gets the advert id.
     *
     * @return the advert id
     */
    public long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advert id
     */
    public void setAdvertId(long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the advertiser name.
     *
     * @return the advertiser name
     */
    public String getAdvertiserName() {
        return advertiserName;
    }

    /**
     * Sets the advertiser name.
     *
     * @param advertiserName the advertiser name
     */
    public void setAdvertiserName(String advertiserName) {
        this.advertiserName = advertiserName;
    }

    /**
     * Gets the coupon remark.
     *
     * @return the coupon remark
     */
    public String getCouponRemark() {
        return couponRemark;
    }

    /**
     * Sets the coupon remark.
     *
     * @param couponRemark the coupon remark
     */
    public void setCouponRemark(String couponRemark) {
        this.couponRemark = couponRemark;
    }

    /**
     * Gets the banner png url.
     *
     * @return the banner png url
     */
    public String getBannerPngUrl() {
        return bannerPngUrl;
    }

    /**
     * Sets the banner png url.
     *
     * @param bannerPngUrl the banner png url
     */
    public void setBannerPngUrl(String bannerPngUrl) {
        this.bannerPngUrl = bannerPngUrl;
    }

    /**
     * Gets the thumbnail png url.
     *
     * @return the thumbnail png url
     */
    public String getThumbnailPngUrl() {
        return thumbnailPngUrl;
    }

    /**
     * Sets the thumbnail png url.
     *
     * @param thumbnailPngUrl the thumbnail png url
     */
    public void setThumbnailPngUrl(String thumbnailPngUrl) {
        this.thumbnailPngUrl = thumbnailPngUrl;
    }

    /**
     * Gets the title.
     *
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the title.
     *
     * @param title the title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Gets the vice title.
     *
     * @return the vice title
     */
    public String getViceTitle() {
        return viceTitle;
    }

    /**
     * Sets the vice title.
     *
     * @param viceTitle the vice title
     */
    public void setViceTitle(String viceTitle) {
        this.viceTitle = viceTitle;
    }

    /**
     * Gets the start valid.
     *
     * @return the start valid
     */
    public String getStartValid() {
        return startValid;
    }

    /**
     * Sets the start valid.
     *
     * @param startValid the start valid
     */
    public void setStartValid(String startValid) {
        this.startValid = startValid;
    }

    /**
     * Gets the end valid.
     *
     * @return the end valid
     */
    public String getEndValid() {
        return endValid;
    }

    /**
     * Sets the end valid.
     *
     * @param endValid the end valid
     */
    public void setEndValid(String endValid) {
        this.endValid = endValid;
    }

    /**
     * Gets the promote url.
     *
     * @return the promote url
     */
    public String getPromoteUrl() {
        return promoteUrl;
    }

    /**
     * Sets the promote url.
     *
     * @param promoteUrl the promote url
     */
    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    /**
     * Gets the coupon price.
     *
     * @return the coupon price
     */
    public long getCouponPrice() {
        return couponPrice;
    }

    /**
     * Sets the coupon price.
     *
     * @param couponPrice the coupon price
     */
    public void setCouponPrice(long couponPrice) {
        this.couponPrice = couponPrice;
    }

    /**
     * Gets the coupon type.
     *
     * @return the coupon type
     */
    public int getCouponType() {
        return couponType;
    }

    /**
     * Sets the coupon type.
     *
     * @param couponType the coupon type
     */
    public void setCouponType(int couponType) {
        this.couponType = couponType;
    }

    /**
     * Gets the code content.
     *
     * @return the code content
     */
    public String getCodeContent() {
        return codeContent;
    }

    /**
     * Sets the code content.
     *
     * @param codeContent the code content
     */
    public void setCodeContent(String codeContent) {
        this.codeContent = codeContent;
    }

    /**
     * Gets the code passwd.
     *
     * @return the code passwd
     */
    public String getCodePasswd() {
        return codePasswd;
    }

    /**
     * Sets the code passwd.
     *
     * @param codePasswd the code passwd
     */
    public void setCodePasswd(String codePasswd) {
        this.codePasswd = codePasswd;
    }

}
