/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.message.consumer;

import cn.com.tuia.advert.message.RedisMessageChannel;
import cn.com.tuia.advert.message.consumer.AbstractRedisMessageHandle;
import cn.com.tuia.advert.message.consumer.RedisMessageHandle;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisMsgSubscriber
implements MessageListener,
ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger(RedisMsgSubscriber.class);
    private final ExecutorService pool = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newFixedThreadPool(5));
    private Map<RedisMessageChannel, AbstractRedisMessageHandle> handlesMap = new HashMap<RedisMessageChannel, AbstractRedisMessageHandle>();
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<String> channels = new HashSet<String>();
    private RedisTemplate<String, String> redisTemplate;

    public RedisMsgSubscriber(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public RedisMsgSubscriber(RedisTemplate<String, String> redisTemplate, Map<RedisMessageChannel, ? extends AbstractRedisMessageHandle> handlesMap) {
        this(redisTemplate);
        this.handlesMap.putAll(handlesMap);
        Set<RedisMessageChannel> redisMessageChannels = handlesMap.keySet();
        for (RedisMessageChannel channel : redisMessageChannels) {
            this.channels.add(channel.getChannel());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map map = applicationContext.getBeansOfType(AbstractRedisMessageHandle.class);
        Collection handles = map.values();
        for (AbstractRedisMessageHandle handle : handles) {
            RedisMessageHandle annotation = handle.getClass().getAnnotation(RedisMessageHandle.class);
            if (annotation == null) continue;
            RedisMessageChannel channel = annotation.value();
            this.channels.add(channel.getChannel());
            this.handlesMap.put(channel, handle);
        }
    }

    public void onMessage(Message message, byte[] pattern) {
        byte[] body = message.getBody();
        byte[] channel = message.getChannel();
        String msgContent = (String)this.redisTemplate.getValueSerializer().deserialize(body);
        String topic = (String)this.redisTemplate.getStringSerializer().deserialize(channel);
        log.info(topic + ";msg=" + message);
        AbstractRedisMessageHandle handle = null;
        RedisMessageChannel channelEnum = RedisMessageChannel.getByChannel(topic);
        if (channelEnum == null) {
            this.logger.error("channel:[{}] not dedeclared", (Object)channel);
            return;
        }
        if (this.handlesMap != null && !this.handlesMap.isEmpty()) {
            handle = this.handlesMap.get((Object)channelEnum);
        }
        if (handle == null) {
            this.logger.error("not find handle of channel:[{}]", (Object)channel);
            return;
        }
        this.pool.submit(handle.createHandle(channelEnum, msgContent));
    }
}

