package cn.com.tuia.advert.message;

/**
 * Redis 消息频道
 *
 * @author ElinZhou
 * @version $Id: RedisMessageChannel.java , v 0.1 2017/3/10 上午10:03 ElinZhou Exp $
 */
public enum RedisMessageChannel {

     /**
      * 更新广告对象
      */
     UPDATE_ADVERTS_MSG("updateAdvertsMsg"),

    /**
     * 更新广告有效列表
     */
    UPDATE_VALID_ADVERTS_MSG("updateValidAdvertsMsg"),

    /**
     * 更新广告投放地域
     */
    UPDATE_ADVERT_REGION_IDS_MSG("updateAdvertRegionIdsMsg"),

    /**
     * 更新广告定向媒体
     */
    UPDATE_ADVERT_TARGET_APPS_MSG("updateAdvertTargetAppsMsg"),

    /**
     * 更新新老广告关联关系
     */
    UPDATE_OLD_ADVERT_RELATION_MSG("updateOldAdvertRelationMsg"),

    /**
     * 通知该广告该时段状态修改
     */
    UPDATE_ADVERT_IS_PUT("updateAdvertIsPut"),

     /**
      * 通知更新广告有效状态
      */
     UPDATE_ADVERT_VALID_STATUS_MSG("updateAdvertValidStatusMsg"),

    /**
     * 更新广告绑定的app限流
     **/
    UPDATE_ADVERT_LIMITING_MSG("updateAdvertLimitingMsg"),

    /**
     * 广告计划定向配置包消息
     */
    UPDATE_ADVERT_ORIENT_PACKAGE_MSG("updateAdvertOrientPackageMsg"),

    /**
     * 广告标签缓存更新消息
     */
    UPDATE_ADVERT_TAG_MSG("updateAdvertTagMsg"),

    ;

    private String channel;

    RedisMessageChannel(String channel) {
        this.channel = channel;
    }


    public String getChannel() {
        return channel;
    }

    public static String[] channels() {
        RedisMessageChannel[] values = values();
        int length = values.length;
        String[] channels = new String[length];
        for (int i = 0; i < length; i++) {
            channels[i] = values[i].channel;
        }
        return channels;
    }

    public static RedisMessageChannel getByChannel(String channel) {
        RedisMessageChannel[] values = values();
        for (int i = 0; i < values.length; i++) {
            if (values[i].getChannel().equals(channel)) {
                return values[i];
            }
        }
        return null;
    }
}
