/**
 * 文件名： IEngineService.java<br/>
 * 此类描述的是： <br/>
 * 作者: sunjiangrong <br/>
 * 创建时间: 2016年4月27日 下午10:29:43 <br/>
 */
package cn.com.tuia.advert.service;

import cn.com.tuia.advert.exception.ReadableMessageException;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.model.QueryAdvertReq;
import cn.com.tuia.advert.model.QueryAdvertRsp;

/**
 * 广告引擎服务<br/>
 * <功能详细描述>.
 *
 * @author: sunjiangrong
 * @创建时间: 2016年4月27日 下午10:29:43
 * @version:
 */
public interface IEngineService {

    /**
     * 请求广告 提供给兑吧的请求广告接口.
     *
     * @param req the req
     * @return the obtain advert rsp
     * @throws ReadableMessageException the readable message exception
     */
    ObtainAdvertRsp obtainAdvert(ObtainAdvertReq req) throws ReadableMessageException;

    /**
     * 查询广告详情接口.
     *
     * @param req the req
     * @return the query advert rsp
     * @throws ReadableMessageException the readable message exception
     */
    QueryAdvertRsp queryAdvert(QueryAdvertReq req) throws ReadableMessageException;

}
