package cn.com.tuia.advert.enums;


import org.apache.commons.lang.StringUtils;

/**
 * 广告订单拓展字段key
 */
public enum AdvertOrderJsonKeyEnum {
    
    /** 广告定向配置包. */
    KEY_ADVERT_ORIENTATION_ID("advertOrientationId","广告定向配置包"),

    /** 发券次数. */
    KEY_TIMES("times","发券次数"),
    
    /** 策略类型. */
    KEY_STRATEGY_TYPE("strategyType","策略类型"),
    
    /** 轮流策略类型. */
    KEY_TURNS_STRATEGY_TYPE("turnsStrategyType","轮流投放策略"),
    
    /** 计费方式. */
    KEY_CHARGE_TYPE("chargeType","计费方式"),
    
    /** 当前出价. */
    KEY_FEE("fee","当前出价"),
    
    /** 应用ID. */
    KEY_APP_ID("appId","应用ID"),
    
    /** 活动ID. */
    KEY_ACTIVITY_ID("activityId","活动ID"),
    
    /** 活动来源. */
    KEY_ACTIVITY_SOURCE("activitySource","活动来源"),

    KEY_PRIVILEGE("privilege","是否是特权广告"),
    
    KEY_ACCOUNT_ID("accountId","广告主id"),
    
    KEY_AGENT_ID("agentId","代理商id"),
    
    KEY_TYPE("type","投放类型"),

    KEY_PACKAGE_TYPE("packageType","投放的策略包类型"),

    KEY_ACTIVITY_TYPE("activityType","定向配置活动类型：1-插件工具、2-活动工具、3-直投页、-1-不限"),

    KEY_EXPS("exps","实验列表");


    /** 代码 */
    private String code;
    /** 描述 */
    private String desc;

    private AdvertOrderJsonKeyEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static AdvertOrderJsonKeyEnum getByCode(String code){
        for(AdvertOrderJsonKeyEnum enumVal : AdvertOrderJsonKeyEnum.values()){
            if(StringUtils.equals(code,enumVal.getCode())){
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
