/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.message.producter;

import cn.com.tuia.advert.message.producter.AbstractMsgPublisher;
import cn.com.tuia.advert.message.producter.MessageConvertible;
import cn.com.tuia.advert.message.producter.MessagePublisher;
import cn.com.tuia.advert.message.producter.message.Message;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MsgPublisherDispatcher
implements ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConcurrentHashMap<Class<? extends AbstractMsgPublisher>, AbstractMsgPublisher> publishers;

    public void publish(Message message) {
        if (message == null) {
            this.logger.error("message is null");
            throw new IllegalArgumentException("message should not be null");
        }
        MessagePublisher service = message.getClass().getAnnotation(MessagePublisher.class);
        if (service.value().getClass().equals(AbstractMsgPublisher.class)) {
            this.logger.error("Message annotation should not be AbstractMsgPublisher");
            throw new IllegalArgumentException();
        }
        AbstractMsgPublisher publisher = this.publishers.get(service.value());
        if (publisher == null) {
            this.logger.error("{} not exist in IOC", (Object)service.value().getSimpleName());
            throw new NullPointerException();
        }
        if (message instanceof MessageConvertible) {
            ((MessageConvertible)((Object)message)).toMessage();
        }
        publisher.publish(message);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beans = applicationContext.getBeansOfType(AbstractMsgPublisher.class);
        this.publishers = new ConcurrentHashMap(beans.size());
        for (AbstractMsgPublisher publisher : beans.values()) {
            this.publishers.put(publisher.getClass(), publisher);
        }
    }
}

