package cn.com.tuia.advert.enums;

/**
 * Created by huangch on 2017/12/25 15:23
 * description: 广告失效的原因枚举类
 *
 * @since JDK 1.6
 */
public enum AdvertInvalidReasonEnum {

    ADVERTISER_ACCOUNT_FROZEN(1, "advertiserDingNoticeProcess", "advertiserDingNoticeProcess", "广告主账号被冻结"),

    ADVERTISER_BALANCE_NOT_ENOUGH(2, "advertiserDingNoticeProcess", "advertiserDingNoticeProcess", "广告主账户余额不足"),

    ADVERTISER_BUDGET_NOT_ENOUGH(3, "advertiserDingNoticeProcess", "advertiserDingNoticeProcess", "广告主账户预算不足"),

    ADVERTISER_SUSPENSION_ADVERT(4, "advertSelfInvalid", "advertDingNoticeProcess", "广告主暂停广告计划"),

    ADVERT_BUDGET_NOT_ENOUGH(5, "advertBudgetNotEnough", "advertDingNoticeProcess", "广告预算不足"),

    ADVERT_CHANGE_WAITING_AUDIT(6, "advertSelfInvalid", "advertDingNoticeProcess", "广告审核状态发生变化，变为待审"),

    ADVERT_CHANGE_REFUSE(7, "advertChangeRefuse", "advertDingNoticeProcess", "广告审核状态发生变化，二次审核变为被拒绝"),

    ADVERT_LANDING_PAGE_REFUSE(8, "advertSelfInvalid", "advertDingNoticeProcess", "广告审核状态发生变化，落地页审核被拒绝导致广告失效"),

    ADVERT_PLAN_EXPIRE(9, "advertSelfInvalid", "advertDingNoticeProcess", "广告投放日期到期"),

    ADVERT_STOCK_NOT_ENOUGH(10, "advertSelfInvalid", "advertDingNoticeProcess", "广告消耗完毕（库存不足）"),

    ORIENT_PKG_MATERIAL_REFUSE(11, "orientPkgMaterialRefuse", "orientPkgDingNoticeProcess", "广告配置包配置的定向素材审核状态变为被拒绝"),

    ORIENT_PKG_MATERIAL_SHIELD(12, "orientPkgMaterialShield", "orientPkgDingNoticeProcess", "广告配置包配置的定向素材被屏蔽"),

    ORIENT_PKG_BUDGET_NOT_ENOUGH(13, "orientPkgBudgetNotEnough", "orientPkgDingNoticeProcess", "广告的配置包预算不足"),

    ORIENT_PKG_TARGET_APP_OFFLINE(14, "orientPkgTargetAppOffline", "orientPkgDingNoticeProcess", "广告的配置包配置的定向媒体下线"),

    ORIENT_PKG_TARGET_APP_SHIELD(15, "orientPkgTargetAppShield", "orientPkgDingNoticeProcess", "广告的配置包配置的定向媒体被屏蔽");

    //原因类型
    private Integer type;

    private String beanClass;

    private String processClass;

    //原因
    private String reason;

    private AdvertInvalidReasonEnum(Integer type, String beanClass, String processClass, String reason) {
        this.type = type;
        this.beanClass = beanClass;
        this.processClass = processClass;
        this.reason = reason;
    }

    public static String getReasonByType(Integer type) {
        if (type == null) {
            return "";
        }

        for (AdvertInvalidReasonEnum reasonEnum : values()) {
            if (type.equals(reasonEnum.getType())) {
                return reasonEnum.getReason();
            }
        }

        return "";
    }

    public static String getBeanClassByType(Integer type) {
        if (type == null) {
            return "";
        }

        for (AdvertInvalidReasonEnum reasonEnum : values()) {
            if (type.equals(reasonEnum.getType())) {
                return reasonEnum.getBeanClass();
            }
        }

        return "";
    }

    public static String getProcessClassByType(Integer type) {
        if (type == null) {
            return "";
        }

        for (AdvertInvalidReasonEnum reasonEnum : values()) {
            if (type.equals(reasonEnum.getType())) {
                return reasonEnum.getProcessClass();
            }
        }

        return "";
    }

    public static int getInvalidTypeByValidStatus(int validStatus) {
        switch (validStatus) {
            case 5:
                return ADVERTISER_BALANCE_NOT_ENOUGH.getType();
            case 6:
                return ADVERTISER_BUDGET_NOT_ENOUGH.getType();
            case 7:
                return ADVERT_BUDGET_NOT_ENOUGH.getType();
            case 8:
                return ADVERT_STOCK_NOT_ENOUGH.getType();
            case 13:
                return ORIENT_PKG_BUDGET_NOT_ENOUGH.getType();
            default:
                return 0;
        }
    }

    public String getProcessClass() {
        return processClass;
    }

    public Integer getType() {
        return type;
    }

    public String getBeanClass() {
        return beanClass;
    }

    public String getReason() {
        return reason;
    }
}
