package cn.com.tuia.advert.message.consumer;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import cn.com.duiba.wolf.concurrent.AbortPolicyWithReport;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by hujinliang on 2018/3/13.
 */
@Configuration
public class ExecutorServiceAutoConfiguration {
    @Bean(name = "consumeExecutorService", destroyMethod = "shutdown")
    public ExecutorService consumeExecutorService(){
        BlockingQueue<Runnable> queue = new ArrayBlockingQueue<>(2000);
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(10,30,
                60L, TimeUnit.SECONDS,
                queue,
                new NamedThreadFactory("RedisConsume"),
                new AbortPolicyWithReport());
        return new ThreadPoolExecutorWrapper(threadPool, 3000L);
    }
}
