/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.message.producter;

import cn.com.tuia.advert.message.producter.AbstractMsgPublisher;
import cn.com.tuia.advert.message.producter.message.Message;
import cn.com.tuia.advert.message.producter.message.RedisMessage;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisMsgPublisher
extends AbstractMsgPublisher {
    protected RedisTemplate<String, String> redisTemplate;

    public RedisMsgPublisher(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void publish(Message message) {
        if (!(message instanceof RedisMessage)) {
            throw new IllegalArgumentException("message must be RedisMessage");
        }
        RedisMessage redisMessage = (RedisMessage)message;
        if (redisMessage.getChannel() == null) {
            throw new IllegalArgumentException("channel should not be null");
        }
        this.redisTemplate.convertAndSend(redisMessage.getChannel().getChannel(), (Object)redisMessage.getMessage());
    }
}

