package cn.com.tuia.advert.model;

import com.alibaba.fastjson.JSON;
import org.joda.time.DateTime;

import java.io.Serializable;
import java.util.Map;

/**
 * 激励广告请求
 */
public class ObtainEncourageAdvertReq implements Serializable {

    private static final long serialVersionUID = 7371676541293127274L;

    /**
     * 点击按钮的用户id
     */
    private Long consumerId;

    /**
     * 点击按钮的客户端的UA
     */
    private String ua;

    /**
     * 点击按钮的客户端的ip
     */
    private String ip;

    /**
     * 发生点击事件的app的id
     */
    private Long appId;

    /**
     * 福袋被添加的活动ID或者直投页ID
     */
    private Long activityId;

    /**
     * 客户端时间戳，毫秒
     */
    private Long timestamp;

    /**
     * 用户使用系统
     */
    private String os;

    /**
     * 点击：0，曝光：1，请求：2，发券：3，计费：4
     */
    private String type;

    private String userAgent;

    /**
     * 在cookie中写入的设备id
     */
    private String deviceId;

    /**
     * 当前系统时间
     */
    private String time;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 广告ID
     */
    private Long advertId;

    /**
     * 页面类型，1-活动、2-直投页
     */
    private Integer pageType;

    /**
     * 日志扩展map，仅用于记录日志
     */
    private Map<String, String> logExtMap;

    public ObtainEncourageAdvertReq() {
        super();
        DateTime nowTime = new DateTime();
        this.time = nowTime.toString("yyyy-MM-dd HH:mm:ss");
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Integer getPageType() {
        return pageType;
    }

    public void setPageType(Integer pageType) {
        this.pageType = pageType;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Map<String, String> getLogExtMap() {
        return logExtMap;
    }

    public void setLogExtMap(Map<String, String> logExtMap) {
        this.logExtMap = logExtMap;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
