/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.enums;

import cn.com.tuia.advert.enums.PlatformTypeEnum;
import com.google.common.collect.Maps;
import java.util.Map;

public enum ResourceRepeatLunchTypeEnum {
    IOS_DEFULT(1, "ios\u9ed8\u8ba4\u8d44\u6e90\u914d\u7f6e"),
    IOS_SPECIAL(2, "ios\u7279\u6b8a\u8d44\u6e90\u914d\u7f6e"),
    UN_IOS_DEFULT(3, "\u975eios\u9ed8\u8ba4\u8d44\u6e90\u914d\u7f6e"),
    UN_IOS_SPECIAL(4, "\u975eios\u7279\u6b8a\u8d44\u6e90\u914d\u7f6e"),
    TRADE_APP(5, "\u5176\u4ed6");

    private String desc;
    private Integer code;
    private static Map<Integer, ResourceRepeatLunchTypeEnum> enumMap;

    private ResourceRepeatLunchTypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public static ResourceRepeatLunchTypeEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    public static ResourceRepeatLunchTypeEnum groupType(Integer type) {
        switch (type) {
            case 1: 
            case 2: {
                return IOS_DEFULT;
            }
            case 3: 
            case 4: {
                return UN_IOS_DEFULT;
            }
        }
        return ResourceRepeatLunchTypeEnum.getByCode(type);
    }

    public static Integer getByPlatform(String platform) {
        if (PlatformTypeEnum.getByDesc(platform).equals((Object)PlatformTypeEnum.IOS)) {
            return ResourceRepeatLunchTypeEnum.IOS_DEFULT.code;
        }
        return ResourceRepeatLunchTypeEnum.UN_IOS_DEFULT.code;
    }

    static {
        enumMap = Maps.newHashMap();
        for (ResourceRepeatLunchTypeEnum it : ResourceRepeatLunchTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }
}

