package cn.com.tuia.advert.enums;


/**
 * 
 * ClassName: AdvertTypeEnum <br/>
 * Function: 广告类型. <br/>
 * date: 2018年12月18日 下午8:18:08 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AdvertTypeEnum {
    
    HD_ADVERT_TYPE(1,"互动广告"),
    
    SHOW_ADVERT_TYPE(2,"展示广告"),

    ENCOURAGE_ADVERT_TYPE(3,"激励广告");


    /** 代码 */
    private Integer code;
    /** 描述 */
    private String desc;

    private AdvertTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static AdvertTypeEnum getByCode(Integer code){
        for(AdvertTypeEnum enumVal : AdvertTypeEnum.values()){
            if(code == enumVal.getCode()){
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
