package cn.com.tuia.advert.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by MichealWang on 2018/10/29 0029.
 * 广告ocpc后端数据 调整因子
 */
public enum AdvertSubtypeEnum {

    CVR(0, "落地页转化"),
    INSTALL(1, "安装"),
    START(2, "激活"),
    REGISTER(3, "注册"),
    ACTIVITY(4, "激活"),
    LOGIN(5, "登录"),
    PAY(6, "付费"),
    ENTRY(7, "进件"),
    FINISH(8, "完件"),
    SIGN_FOR(9, "签收");

    private Integer subtype;

    private String desc;

    public Integer getSubtype() {
        return subtype;
    }

    public void setSubtype(Integer subtype) {
        this.subtype = subtype;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    AdvertSubtypeEnum(Integer subtype, String desc) {
        this.subtype = subtype;
        this.desc = desc;
    }

    private static Map<Integer, AdvertSubtypeEnum> enumMap = Maps.newHashMap();

    static {
        for (AdvertSubtypeEnum it : AdvertSubtypeEnum.values()) {
            enumMap.put(it.getSubtype(), it);
        }
    }

    public static AdvertSubtypeEnum getBySubtype(Integer subtype) {
        return enumMap.get(subtype);
    }

}
