package cn.com.tuia.advert.enums;


/**
 * 投放目标类型
 */
public enum PutTargetTypeEnum {
    default_type(0, 1, "默认"),
    consume_priority(1, 2, "消耗优先"),
    cost_priority(2, 2, "成本优先"),
    balance_put(3, 2, "均衡投放"),
    manual_target(4, 3, "人工定向");

    private Integer putTargetType;

    private Integer targetAppLimit;

    private String desc;

    PutTargetTypeEnum(Integer putTargetType, Integer targetAppLimit, String desc) {
        this.putTargetType = putTargetType;
        this.targetAppLimit = targetAppLimit;
        this.desc = desc;
    }

    public static Integer getTargetAppLimit(Integer putTargetType) {
        if (putTargetType == null) {
            return 0;
        }
        for (PutTargetTypeEnum typeEnum : values()) {
            if (typeEnum.getPutTargetType().equals(putTargetType)) {
                return typeEnum.getTargetAppLimit();
            }
        }
        return 0;
    }

    public static String getDesc(Integer putTargetType) {
        if (putTargetType == null) {
            return "";
        }
        for (PutTargetTypeEnum typeEnum : values()) {
            if (typeEnum.getPutTargetType().equals(putTargetType)) {
                return typeEnum.getDesc();
            }
        }
        return "";
    }

    public Integer getPutTargetType() {
        return putTargetType;
    }

    public void setPutTargetType(Integer putTargetType) {
        this.putTargetType = putTargetType;
    }

    public Integer getTargetAppLimit() {
        return targetAppLimit;
    }

    public void setTargetAppLimit(Integer targetAppLimit) {
        this.targetAppLimit = targetAppLimit;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

