package cn.com.tuia.advert.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: AdvertRepeatLunchTypeEnum <br/>
 * Function: 广告资源重复发券发券间隔配置类型. <br/>
 * date: 2018年1月29日 下午2:51:23 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public enum ResourceRepeatLunchTypeEnum {
    /** ios默认资源配置 */
    IOS_DEFULT(1, "ios默认资源配置"),

    /** ios特殊资源配置 */
    IOS_SPECIAL(2, "ios特殊资源配置"),

    /** 非ios默认资源配置 */
    UN_IOS_DEFULT(3, "非ios默认资源配置"),

    /** 非ios特殊资源配置 */
    UN_IOS_SPECIAL(4, "非ios特殊资源配置"),

    /** 行业分媒体*/
    TRADE_APP(5, "其他");

    private String desc;

    private Integer code;

    ResourceRepeatLunchTypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, ResourceRepeatLunchTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (ResourceRepeatLunchTypeEnum it : ResourceRepeatLunchTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static ResourceRepeatLunchTypeEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
    
    /**
     * 
     * groupType:(根据平台聚合类型，ios都为ios，非ios都是非ios). <br/>
     *
     * @author chencheng
     * @param type ResourceRepeatLunchTypeEnum的code
     * @return
     * @since JDK 1.8
     */
    public static ResourceRepeatLunchTypeEnum groupType(Integer type) {
        switch (type) {
            case 1:
            case 2:
                return IOS_DEFULT;
            case 3:
            case 4:
                return UN_IOS_DEFULT;
            default:
                return getByCode(type);
        }
    }
    
    /**
     * 
     * getByPlatform:(根据ua获取缓存key). <br/>
     *
     * @author chencheng
     * @param platform
     * @return
     * @since JDK 1.8
     */
    public static Integer getByPlatform(String platform) {
        if (PlatformTypeEnum.getByDesc(platform).equals(PlatformTypeEnum.IOS)) {
            return IOS_DEFULT.code;
        }else {
            return UN_IOS_DEFULT.code;
        }
    }
    
}
