package cn.com.tuia.advert.enums;


import org.apache.commons.lang3.StringUtils;

import java.util.Map;

public enum ClickSourceEnum {

    ACT_PAGE(1, "活动页面"),

    PRIZE_PAGE(2, "我的奖品页");

    private int source;

    private String desc;

    ClickSourceEnum(int source, String desc) {
        this.source = source;
        this.desc = desc;
    }

    public static boolean checkIsMyPrice(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String clickSource = map.get("clickSource");
        return StringUtils.isNotBlank(clickSource) && Integer.valueOf(clickSource) == PRIZE_PAGE.source;
    }

    public int getSource() {
        return source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
