package cn.com.tuia.advert.enums.userinfo;

import cn.com.tuia.advert.enums.UserResourceEnum;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Wangpf
 * @description 工作状态枚举类
 * @date 2019/8/1 10:32
 */
public enum WorkStateEnum {


    /**
     * 学生
     */
    STUDENT(0,"student"),


    /**
     * 工作状态
     */
    WROK(1,"work"),


    /**
     * 其他状态
     */
    WORKOTHER(1,"workother");

    private int code;

    private String desc;

    WorkStateEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static Optional<List<String>> getWorkStateByCode(int code){
        List<String> wordList = Stream.of(WorkStateEnum.values()).filter(workState -> workState.getCode() == code)
                .map(WorkStateEnum::getDesc).collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(wordList)){
            return Optional.of(wordList);
        }
        return Optional.empty();
    }

    public static boolean isCorrect(Integer code){
        if(code != null){
            return getWorkStateByCode(code).isPresent();
        }
        return false;
    }

}
