/**
 * Project Name:tuia-clent<br>
 * File Name:ObtainAdvertExReq.java<br>
 * Package Name:cn.com.tuia.advert.model<br>
 * Date:2016年6月16日下午5:14:51<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.tuia.advert.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.joda.time.DateTime;

import com.alibaba.fastjson.JSON;

/**
 * ClassName: ObtainShowAdvertReq <br/>
 * Function: 展示广告请求 <br/>
 * date: 2018年8月28日 上午10:08:01 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class ObtainShowAdvertReq implements Serializable {

    private static final long   serialVersionUID = 7371676541293127274L;

    /** 点击按钮的用户id */
    private Long                consumerId;

    /** 点击按钮的客户端的UA */
    private String              ua;

    /** 订单id集合 */
    private List<String>        orderIds;

    /** 点击按钮的客户端的ip */
    private String              ip;

    /** 发生点击事件的app的id */
    private Long                appId;

    /** 福袋被添加的活动ID */
    private Long                activityId;

    /** 活动标签. */
    private String              tag;

    /** 客户端时间戳，毫秒 */
    private Long                timestamp;

    /** 用户使用系统 */
    private String              os;

    /** 点击：0，曝光：1，请求：2，发券：3，计费：4 */
    private String              type;

    private String              userAgent;

    /** 在cookie中写入的设备id */
    private String              deviceId;

    /** 当前系统时间 */
    private String              time;

    /** 广告位ID */
    private Long                slotId;

    /** 广告ID */
    private Long                advertId;

    /** 活动类型 插件活动为 1 */
    private Integer             activityType;

    /** 活动使用类型，0：普通活动，1：商业化活动,2:推啊活动。 用于区分定制化广告和白名单广告 2016-12-20 */
    private Integer             activityUseType;

    /** 兑吧活动类型 ， 从兑吧传过来的活动类型，避免tuia-engine再次查询而形成相互依赖 2016-12-20 */
    private Integer             duibaActivityType;

    /** 兑吧活动id ， 从兑吧传过来的活动id，避免tuia-engine再次查询而形成相互依赖 2016-12-20 */
    private Long                duibaActivityId;

    /** 活动场景类型 1-插件工具、2-活动工具、3-直投页，4展示广告 */
    private Integer             activitySceneType;

    /*** 当前用户是否代理/VPN流量 true:是，false：否 */
    private Boolean             isProxy          = Boolean.FALSE;

    /** 日志扩展map，仅用于记录日志 */
    private Map<String, String> logExtMap;

    /** 素材类型,1-展示广告大图、2-展示广告小图 */
    private Integer             materialType;

    /** 本次请求期望返回广告个数 */
    private Integer             advertCount;

    /** 投放类型：1-福袋 2-直投 3-浮标 */
    private int                 deliveryType;

    /** app安装列表*/
    private String apps;

    /** 操作系统版本*/
    private String osVersion;

    /**
     * deliveryType.
     *
     * @return the deliveryType
     * @since JDK 1.8
     */
    public int getDeliveryType() {
        return deliveryType;
    }

    /**
     * deliveryType.
     *
     * @param deliveryType the deliveryType to set
     * @since JDK 1.8
     */
    public void setDeliveryType(int deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Boolean getProxy() {
        return isProxy;
    }

    public void setProxy(Boolean proxy) {
        isProxy = proxy;
    }

    /**
     * advertCount.
     *
     * @return the advertCount
     * @since JDK 1.8
     */
    public Integer getAdvertCount() {
        return advertCount;
    }

    /**
     * advertCount.
     *
     * @param advertCount the advertCount to set
     * @since JDK 1.8
     */
    public void setAdvertCount(Integer advertCount) {
        this.advertCount = advertCount;
    }

    /**
     * materialType.
     *
     * @return the materialType
     * @since JDK 1.8
     */
    public Integer getMaterialType() {
        return materialType;
    }

    /**
     * materialType.
     *
     * @param materialType the materialType to set
     * @since JDK 1.8
     */
    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }

    public Integer getActivitySceneType() {
        return activitySceneType;
    }

    public void setActivitySceneType(Integer activitySceneType) {
        this.activitySceneType = activitySceneType;
    }

    public Map<String, String> getLogExtMap() {
        return logExtMap;
    }

    public void setLogExtMap(Map<String, String> logExtMap) {
        this.logExtMap = logExtMap;
    }

    public Integer getActivityUseType() {
        return activityUseType;
    }

    public void setActivityUseType(Integer activityUseType) {
        this.activityUseType = activityUseType;
    }

    public Integer getDuibaActivityType() {
        return duibaActivityType;
    }

    public void setDuibaActivityType(Integer duibaActivityType) {
        this.duibaActivityType = duibaActivityType;
    }

    public Long getDuibaActivityId() {
        return duibaActivityId;
    }

    public void setDuibaActivityId(Long duibaActivityId) {
        this.duibaActivityId = duibaActivityId;
    }

    public ObtainShowAdvertReq() {
        super();
        DateTime nowTime = new DateTime();
        String serverTime = nowTime.toString("yyyy-MM-dd HH:mm:ss");
        this.time = serverTime;
    }

    /**
     * activityType.
     * 
     * @return the activityType
     * @since JDK 1.6
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     * 
     * @param activityType the activityType to set
     * @since JDK 1.6
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    /**
     * advertId.
     * 
     * @return the advertId
     * @since JDK 1.6
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     * 
     * @param advertId the advertId to set
     * @since JDK 1.6
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * slotId.
     * 
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     * 
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * timestamp.
     * 
     * @return the timestamp
     * @since JDK 1.6
     */
    public Long getTimestamp() {
        return timestamp;
    }

    /**
     * timestamp.
     * 
     * @param timestamp the timestamp to set
     * @since JDK 1.6
     */
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * time.
     * 
     * @return the time
     * @since JDK 1.6
     */
    public String getTime() {
        return time;
    }

    /**
     * time.
     * 
     * @param time the time to set
     * @since JDK 1.6
     */
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * consumerId.
     * 
     * @return the consumerId
     * @since JDK 1.6
     */
    public Long getConsumerId() {
        return consumerId;
    }

    /**
     * consumerId.
     * 
     * @param consumerId the consumerId to set
     * @since JDK 1.6
     */
    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    /**
     * ua.
     * 
     * @return the ua
     * @since JDK 1.6
     */
    public String getUa() {
        return ua;
    }

    /**
     * ua.
     * 
     * @param ua the ua to set
     * @since JDK 1.6
     */
    public void setUa(String ua) {
        this.ua = ua;
    }

    /**
     * orderIds.
     *
     * @return the orderIds
     * @since JDK 1.8
     */
    public List<String> getOrderIds() {
        return orderIds;
    }

    /**
     * orderIds.
     *
     * @param orderIds the orderIds to set
     * @since JDK 1.8
     */
    public void setOrderIds(List<String> orderIds) {
        this.orderIds = orderIds;
    }

    /**
     * ip.
     * 
     * @return the ip
     * @since JDK 1.6
     */
    public String getIp() {
        return ip;
    }

    /**
     * ip.
     * 
     * @param ip the ip to set
     * @since JDK 1.6
     */
    public void setIp(String ip) {
        this.ip = ip;
    }

    /**
     * appId.
     * 
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     * 
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * activityId.
     * 
     * @return the activityId
     * @since JDK 1.6
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * activityId.
     * 
     * @param activityId the activityId to set
     * @since JDK 1.6
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * tag.
     * 
     * @return the tag
     * @since JDK 1.6
     */
    public String getTag() {
        return tag;
    }

    /**
     * tag.
     * 
     * @param tag the tag to set
     * @since JDK 1.6
     */
    public void setTag(String tag) {
        this.tag = tag;
    }

    /**
     * os.
     * 
     * @return the os
     * @since JDK 1.6
     */
    public String getOs() {
        return os;
    }

    /**
     * os.
     * 
     * @param os the os to set
     * @since JDK 1.6
     */
    public void setOs(String os) {
        this.os = os;
    }

    /**
     * type. s
     * 
     * @return the type
     * @since JDK 1.6
     */
    public String getType() {
        return type;
    }

    /**
     * type.
     * 
     * @param type the type to set
     * @since JDK 1.6
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * userAgent.
     * 
     * @return the userAgent
     * @since JDK 1.6
     */
    public String getUserAgent() {
        return userAgent;
    }

    /**
     * userAgent.
     * 
     * @param userAgent the userAgent to set
     * @since JDK 1.6
     */
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    /**
     * deviceId.
     * 
     * @return the deviceId
     * @since JDK 1.6
     */
    public String getDeviceId() {
        return deviceId;
    }

    /**
     * deviceId.
     * 
     * @param deviceId the deviceId to set
     * @since JDK 1.6
     */
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getApps() {
        return apps;
    }

    public void setApps(String apps) {
        this.apps = apps;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
