/**
 * Project Name:engine-domain File Name:Snippet.java Package Name:cn.com.duiba.tuia.domain.model
 * Date:2018年7月12日下午4:12:45 Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 */

package cn.com.tuia.advert.model.messageDto;

import java.io.Serializable;

/**
 * ClassName: UpdateNewAppTestCacheMsg <br/>
 * Function: 新媒体投放缓存更新 <br/>
 * date: 2018年9月20日 下午8:43:35 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class UpdateNewAppTestCacheMsg implements Serializable {

    private static final long serialVersionUID = 2977223337762119259L;
    /** 可测试的新媒体缓存 */
    public static final int TYPE_NEW_APP_IDS_CACHE = 1;
    /** 媒体对应的已投放广告关系 */
    public static final int TYPE_APP_TEST_TO_ADVERT_CACHE = 2;
    /** 新媒体上不能继续测试的行业缓存 */
    public static final int TYPE_NEW_APP_NOT_TEST_TRADE_CACHE = 3;
    /** 新媒体不可测试广告  */
    public static final int TYPE_NEW_APP_NOT_TEST_ADVERT_CACHE= 4;
    /** 全部能测试的广告  */
    public static final int TYPE_NEW_APP_TEST_ALL_ADVERT_CACHE= 5;

    public static final int TYPE_NEW_APP_TEST_ALL_ADVERT_CACHE_OTHER = 6;

    /** 媒体id */
    private Long    appId;

    /** 类型：1-可测试的新媒体缓存 ,2-媒体对应的已投放广告关系,3-新媒体上不能继续测试的行业缓存,4-新媒体不可测试广告,5-全部能测试的广告, 6-兼容以前的消息而建的,作用如2 */
    private Integer type;

    /** 广告id */
    private Long advertId;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * type.
     *
     * @return the type
     * @since JDK 1.8
     */
    public Integer getType() {
        return type;
    }

    /**
     * type.
     *
     * @param type the type to set
     * @since JDK 1.8
     */
    public void setType(Integer type) {
        this.type = type;
    }

    public UpdateNewAppTestCacheMsg(Long appId, Long advertId, Integer type) {
        super();
        this.appId = appId;
        this.advertId = advertId;
        this.type = type;
    }
    public UpdateNewAppTestCacheMsg(Long appId, Integer type) {
        super();
        this.appId = appId;
        this.type = type;
    }

    public UpdateNewAppTestCacheMsg() {
        super();
    }

}
