package cn.com.tuia.advert.enums;


/**
 * 
 * ClassName: PackageTypeEnum <br/>
 * Function: 配置包的类型. <br/>
 * date: 2019年4月30日 下午2:58:50 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum PackageTypeEnum {
    
    INTERACTIVE_TYPE(1,"人工包"),

    
    DIRECT_TYPE(2,"系统托管包");


    /** 代码 */
    private Integer code;
    /** 描述 */
    private String desc;

    private PackageTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static PackageTypeEnum getByCode(Integer code){
        for(PackageTypeEnum enumVal : PackageTypeEnum.values()){
            if(code == enumVal.getCode()){
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
