package cn.com.tuia.advert.adxService;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.tuia.advert.exception.ReadableMessageException;
import cn.com.tuia.advert.fallback.IAdxServiceFallbackImpl;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.model.QueryAdvertReq;
import cn.com.tuia.advert.model.QueryAdvertRsp;

/**
 * adx出券请求接口
 *
 * @author peanut.huang
 * @date 2019/7/4
 * @since JDK 1.8
 */
@AdvancedFeignClient(fallback = IAdxServiceFallbackImpl.class)
public interface AdxEngineService {

    /**
     * adx预发券请求
     *
     * @param req  req#adxLoadType，1：预发券
     * @fallback 降级处理，请做好兼容 {@link IAdxServiceFallbackImpl#preLoadAdvert}
     * @return
     */
    @FeignHystrixCommand(threadPoolKey = "adx-load-advert")
    @FeignHystrixProperty.FeignHystrixPropertys({
        @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value = "50"),
        @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "100")
    })
    ObtainAdvertRsp preLoadAdvert(ObtainAdvertReq req);


    /**
     * adx真实发券请求
     *
     * @param req  req#adxLoadType 2：真实发券
     * @fallback 降级处理，请做好兼容 {@link IAdxServiceFallbackImpl#actLoadAdvert}
     * @return
     */
    ObtainAdvertRsp actLoadAdvert(ObtainAdvertReq req);

    /**
     * 查询广告详情接口.
     *
     * @param req the req
     * @return the query advert rsp
     */
    QueryAdvertRsp queryAdvert(QueryAdvertReq req);
}
