package cn.com.tuia.advert.enums;


/**
 * 
 * ClassName: PkgPutTypeEnum <br/>
 * Function: 配置投放类型枚举. <br/>
 * date: 2018年12月18日 下午7:54:09 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum PkgPutTypeEnum {
    
    INTERACTIVE_TYPE(0,"互动广告投放类型"),

    
    DIRECT_TYPE(1,"活动直投广告落地页");


    /** 代码 */
    private Integer code;
    /** 描述 */
    private String desc;

    private PkgPutTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static PkgPutTypeEnum getByCode(Integer code){
        for(PkgPutTypeEnum enumVal : PkgPutTypeEnum.values()){
            if(code == enumVal.getCode()){
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
