/**
 * Project Name:engine-service<br>
 * File Name:NotifyEngineMessage.java<br>
 * Package Name:cn.com.duiba.tuia.message.messagebody<br>
 * Date:2016年12月1日下午5:07:38<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.tuia.advert.model;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: NotifyEngineMessage <br/>
 * Function: 通知引擎请求参数. <br/>
 * date: 2016年12月1日 下午5:07:38 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class NotifyEngineMessage implements Serializable {

    private static final long serialVersionUID               = 1L;

    /** 刷新广告缓存通知类型. */
    public static final int   REFRESH_ADVERT                 = 1;

    /** 刷新APP缓存通知类型. */
    public static final int   REFRESH_APP                    = 2;

    /** 刷新活动白名单缓存通知类型. */
    public static final int   REFRESH_ACTIVITY_WHITE_LIST    = 3;

    /** 刷新媒体白名单缓存通知类型. */
    public static final int   REFRESH_APP_WHITE_LIST         = 4;

    /** 刷新广告定向媒体缓存通知类型. */
    public static final int   REFRESH_ADVERT_TARGET_APP_LIST = 5;

    /** The ids. */
    private List<Long>        ids;

    /** 通知类型. */
    private Integer           type;

    /** The id. */
    private Long              id;

    /** The type. */
    private Integer           status;

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
