package cn.com.tuia.advert.enums;


import org.apache.commons.lang.StringUtils;

/**
 * 广告订单拓展字段key
 */
public enum AdvertOrderJsonKeyEnum {
    
    /** 广告定向配置包. */
    KEY_ADVERT_ORIENTATION_ID("advertOrientationId","广告定向配置包"),

    /** 发券次数. */
    KEY_TIMES("times","发券次数"),
    
    /** 策略类型. */
    KEY_STRATEGY_TYPE("strategyType","策略类型"),
    
    /** 轮流策略类型. */
    KEY_TURNS_STRATEGY_TYPE("turnsStrategyType","轮流投放策略"),
    
    /** 计费方式. */
    KEY_CHARGE_TYPE("chargeType","计费方式"),
    
    /** 当前出价. */
    KEY_FEE("fee","当前出价"),
    
    /** 应用ID. */
    KEY_APP_ID("appId","应用ID"),
    
    /** 活动ID. */
    KEY_ACTIVITY_ID("activityId","活动ID"),
    
    /** 活动来源. */
    KEY_ACTIVITY_SOURCE("activitySource","活动来源"),

    KEY_PRIVILEGE("privilege","是否是特权广告"),
    
    KEY_ACCOUNT_ID("accountId","广告主id"),
    
    KEY_AGENT_ID("agentId","代理商id"),
    
    KEY_TYPE("type","投放类型"),

    KEY_PACKAGE_TYPE("packageType","投放的策略包类型"),

    KEY_ACTIVITY_TYPE("activityType","活动类型：1-插件工具、2-活动工具、3-直投页，4-展示广告"),

    KEY_EFFECTIVE_MAIN_TYPE("effectiveMainType","生效的主体类型，1-杭州推啊，2-霍尔果斯推啊"),

    KEY_EXPS("exps","实验列表"),

    FLOW_TAG("flowTag"," 流量类型,0普通流量 2优质流量"),

    KEY_APP_FLOW_TYPE("appFlowType","屏蔽流量类型：1-微信,2-QQ,3-支付宝,4-其他"),
    
    WELFARE_FLOW_ADVERT_TYPE("welfareFlow","福利流量类型：0-普通流量，1-福利流量"),

    IS_SMALL_PUT_ON("isSmallPutOn","否是少量试投素材：0：正常素材，1：少量试投素材，2：从少量试投标为正常素材,-1:未知"),

    BAICHUAN_GAME_TAG_TYPE("gameTag","是否为游戏标签中标广告 1-是 0-否 -1 unknown 2-null");

    /** 代码 */
    private String code;
    /** 描述 */
    private String desc;

    private AdvertOrderJsonKeyEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static AdvertOrderJsonKeyEnum getByCode(String code){
        for(AdvertOrderJsonKeyEnum enumVal : AdvertOrderJsonKeyEnum.values()){
            if(StringUtils.equals(code,enumVal.getCode())){
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
