package cn.com.tuia.advert.enums;


import cn.com.tuia.advert.model.AdxLogReq;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import org.apache.commons.lang.StringUtils;

public enum AdxSceneEnum {

    ADX_MEITUAN("0","美团adx"),
    ADX_API("1","互动直投API"),
    ADX_DIRECT("2","adx直投"),
    ADX_ACT("3","adx发券"),
    SDK_DIRECT("4","sdk直投"),

    UNKNOWN("-1","未知");

    private String code;

    private String desc;

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    AdxSceneEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static AdxSceneEnum getAdxMeituanByCode(String code){

        for(AdxSceneEnum adxSceneEnum:AdxSceneEnum.values()){
            if(adxSceneEnum.getCode().equals(code)){
                return adxSceneEnum;
            }
        }

        return UNKNOWN;
    }

    /**
     * 获取adx场景, 算法团队使用
     *  tuia-adx-engine 调用
     * @param adxMediaType
     * @return
     */
    public static String getAdxSceneType(String adxMediaType) {
        if (StringUtils.equals(adxMediaType, ADX_DIRECT.getCode()) ||
                StringUtils.equals(adxMediaType, SDK_DIRECT.getCode())) {
            return adxMediaType;
        }
        return ADX_ACT.getCode();
    }

    /**
     * 获取adx场景, 算法团队使用
     *  tuia-adx-engine 调用
     * @param req
     * @return
     */
    public static String getAdxSceneType(ObtainAdvertReq req) {
        return getAdxSceneType(""+req.getAdxMediaType());
    }

    /**
     * 获取adx场景, 算法团队使用
     *  tuia-adx-engine 调用
     * @param req
     * @return
     */
    public static String getAdxSceneType(AdxLogReq req) {
        return getAdxSceneType(req.getAdxMediaType());
    }
}
