package cn.com.tuia.advert.enums;

import java.util.Objects;

public enum DirectMaterialTypeEnum {

    ADX(1,"adx直投素材"),
    SDK(2,"sdk直投素材");

    private Integer code;

    private String desc;

    DirectMaterialTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 是否为ADX直投
     * @param directMaterialType
     * @return
     */
    public static boolean isAdx(Integer directMaterialType) {
        return Objects.equals(ADX.getCode(), directMaterialType);
    }

    /**
     * 是否为sdk直投
     * @param directMaterialType
     * @return
     */
    public static boolean isSdk(Integer directMaterialType) {
        return Objects.equals(SDK.getCode(), directMaterialType);
    }
}
