package cn.com.tuia.advert.enums;


import org.apache.commons.lang.StringUtils;
/**
 * 屏蔽策略类型
 * Created by zhengjy on 2017/4/17.
 */
public enum StrategyTypeEnum {
    /** 默认流量策略. */
    STRATEGY_TYEP_DEFAULT("","默认流量策略"),

    /** 新媒体流量策略. */
    STRATEGY_TYEP_FLOW("flow","新媒体流量策略");


    /** 代码 */
    private String code;
    /** 描述 */
    private String desc;

    private StrategyTypeEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static StrategyTypeEnum getByCode(String code){
        for(StrategyTypeEnum enumVal : StrategyTypeEnum.values()){
            if(StringUtils.equals(code,enumVal.getCode())){
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
