package cn.com.tuia.advert.enums;

import lombok.Getter;

@Getter
public enum GroupTagEnum {

    NO_CONTROL_GROUP(0, "非对照组"),

    TEST_GROUP(1, "实验组"),

    CONTROL_GROUP(2, "对照组"),


    ;

    private Integer code;

    private String description;

    GroupTagEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }


    /**
     * 是否开启了实验
     * @param groupName
     * @return
     */
    public static boolean openTest(String groupName){

        return TEST_GROUP.getCode().toString().equals(groupName);
    }
}
