package cn.com.tuia.advert.enums;

/**
 * 该枚举 标识落地页是从哪里发送出来 主要用于 日志
 */
public enum PromoteSource {
    /**
     * 广告自己的推广链接
     */
    ADVERT_BASIC(0, "广告推广链接"),

    /**
     * AB Test 测试推广链接
     */
    AB_TEST(1, "AB测试链接"),

    /**
     * 新媒体测试推广链接
     */
    NEW_APP_TEST(2, "新媒体测试链接"),

    /**
     * 定向配置多连接测试 推啊广链接
     */
    ORIENTATION_MORE_URL(3, "定向配置链接"),

    /***
     *特殊广告推广链接
     */
    SPECIAL_ADVERT(4, "特殊广告链接"),

    /***
     *特殊广告推广链接
     */
    DSP_ADVERT(5, "DSP平台adx推广链接");

    private Integer type;

    private String desc;

    PromoteSource(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDescByType(Integer type){
        for (PromoteSource promoteSource : PromoteSource.values()){

            if(promoteSource.getType().equals(type)){
                return promoteSource.getDesc();
            }
        }

        return null;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
