package cn.com.tuia.advert.model;

import lombok.Data;

import java.io.Serializable;

/**
 * 查询adx预发券请求结果
 *
 * @author peanut.huang
 * @date 2019/7/4
 * @since JDK 1.8
 */
public class AdxLoadAdvertDto implements Serializable{

    private static final long serialVersionUID = -4820369952377186775L;

    /**
     * 广告计划id
     */
    private Long advertId;

    /**
     * 配置id
     */
    private Long orientationId;

    /**
     * 素材id
     */
    private Long materialId;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     *  预估arpu
     */
    private Double preArpu;

    /**
     * 预估出价
     */
    private Long fee;

    /**
     * 排序
     */
    private Integer rank;

    /**
     * 调价因子
     */
    private Double adjustPriceFactor;


    /**
     * 预估cvr
     */
    private Double preCvr;

    /**
     * 订单ID
     */
    private String orderId;

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getOrientationId() {
        return orientationId;
    }

    public void setOrientationId(Long orientationId) {
        this.orientationId = orientationId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public Double getPreCtr() {
        return preCtr;
    }

    public void setPreCtr(Double preCtr) {
        this.preCtr = preCtr;
    }

    public Double getPreArpu() {
        return preArpu;
    }

    public void setPreArpu(Double preArpu) {
        this.preArpu = preArpu;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Double getAdjustPriceFactor() {
        return adjustPriceFactor;
    }

    public void setAdjustPriceFactor(Double adjustPriceFactor) {
        this.adjustPriceFactor = adjustPriceFactor;
    }

    public Double getPreCvr() {
        return preCvr;
    }

    public void setPreCvr(Double preCvr) {
        this.preCvr = preCvr;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }
}
