package cn.com.tuia.advert.enums;

import java.util.Objects;

/**
 * [广告分媒体调控]策略状态枚举
 *
 * @author zhangbaiqiang
 * @date 2020/8/6
 */
public enum LayeredStrategyStatusEnum {

    CLOSE(0, "关闭"),
    OPEN(1, "开启");

    private Integer status;
    private String desc;

    LayeredStrategyStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByStatus(Integer status) {
        return Objects.equals(status, OPEN.status) ? OPEN.desc : CLOSE.desc;
    }
}
