package cn.com.tuia.advert.message.producter;

import org.springframework.data.redis.core.RedisTemplate;

import cn.com.tuia.advert.message.producter.message.Message;
import cn.com.tuia.advert.message.producter.message.RedisMessage;

/**
 * Redis消息发送
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RedisAbstractMsgPublisher.java , v 0.1 2017/3/10 上午10:45 ZhouFeng Exp $
 */
public class RedisMsgPublisher extends AbstractMsgPublisher {

    protected RedisTemplate<String,String> redisTemplate;

    public RedisMsgPublisher(RedisTemplate<String,String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void publish(Message message) {
        if (!(message instanceof RedisMessage)) {
            throw new IllegalArgumentException("message must be RedisMessage");
        }

        RedisMessage redisMessage = (RedisMessage) message;

        if (redisMessage.getChannel() == null) {
            throw new IllegalArgumentException("channel should not be null");
        }
        redisTemplate.convertAndSend(redisMessage.getChannel().getChannel(), redisMessage.getMessage());
    }
}
