/**
 * 文件名： IEngineService.java<br/>
 * 此类描述的是： <br/>
 * 作者: sunjiangrong <br/>
 * 创建时间: 2016年4月27日 下午10:29:43 <br/>
 */
package cn.com.tuia.advert.service;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.tuia.advert.exception.ReadableMessageException;
import cn.com.tuia.advert.model.*;
import cn.com.tuia.advert.model.dsp.AdxAdvertPriceDto;

/**
 * 广告引擎服务<br/>
 * <功能详细描述>.
 *
 * @author: sunjiangrong
 * @创建时间: 2016年4月27日 下午10:29:43
 * @version:
 */
@AdvancedFeignClient
public interface IEngineService {

    /**
     * 请求广告 提供给兑吧的请求广告接口.
     *
     * @param req the req
     * @return the obtain advert rsp
     * @throws ReadableMessageException the readable message exception
     */
    ObtainAdvertRsp obtainAdvert(ObtainAdvertReq req) throws ReadableMessageException;

    /**
     * 虚拟广告模拟请求发券
     *
     * @param req
     * @return
     * @throws ReadableMessageException
     */
    ObtainAdvertRsp imitateObtainAdvert(ObtainAdvertReq req) throws ReadableMessageException;

    /**
     * 查询广告详情接口.
     *
     * @param req the req
     * @return the query advert rsp
     * @throws ReadableMessageException the readable message exception
     */
    QueryAdvertRsp queryAdvert(QueryAdvertReq req) throws ReadableMessageException;
    
    /**
     * 
     * 活动请求预加载广告素材
     *
     * @author chencheng
     * @param req
     * @return
     * @since JDK 1.8
     */
    QueryPreloadingAdvertRsp queryPreloadingAdvert(ObtainAdvertReq req);


    /**
     * dsp广告订单保存
     *
     * @param req the req
     * @return the query advert rsp
     * @throws ReadableMessageException the readable message exception
     */
    void insertDspAdvertOrder(ObtainAdvertReq req, AdxAdvertPriceDto adxAdvertPrice);

    /**
     * dsp-engine 发券日志补打
     * @param req
     * @param rsp
     * @param adxAdvertPrice
     */
    void dspLaunchLog(ObtainAdvertReq req,ObtainAdvertRsp rsp, AdxAdvertPriceDto adxAdvertPrice);

    /**
     * 互动广告补打发券日志
     */
    void  reLog(SpmlogReq req);


    /**
     * 联通积分活动-积分消耗记录优化需求 提供的调用的发卷接口
     *
     * @param req
     * @return
     * @throws ReadableMessageException
     */
    ObtainAdvertRsp lianTongIntegralConsumeObtainAdvert(ObtainAdvertReq req) throws ReadableMessageException;
}
