package cn.com.tuia.advert.cache;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lijicong
 * @since 2021-08-02
 */
@Getter
@AllArgsConstructor
public enum RedisKeyEnum implements CacheKeyEnumerable {

    // 新媒体测试
    NMT_BACKFLOW_ADVERTS(RedisCommonKeys.KC154.toString(), "新媒体测试-回流广告"),
    NMT_DAY_LAUNCH(RedisCommonKeys.KC154 + "_DL", "新媒体测试-广告在新媒体的当日发券"),
    NMT_QUIT_TEST(RedisCommonKeys.KC154 + "_QT", "新媒体测试-当日不能继续测试的广告"),
    NMT_QUIT_ADVERTS(RedisCommonKeys.KC154 + "_QA", "新媒体测试-退出机制的广告"),

    // 其他
    ;

    private final String key;
    private final String desc;

    @Override
    public String getSpace() {
        return RedisCommonKeys.APPNAME;
    }
}
