package cn.com.tuia.advert.constants;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lijicong
 * @since 2021-08-02
 */
@Getter
@AllArgsConstructor
public enum SystemConfigKeyEnum {

    // 新媒体测试-新媒体自动回流准入门槛
    NAT_BACKFLOW_PAST_DAYS("new.app.test.backflow.past.days", "15", "媒体过去{}天"),
    NAT_BACKFLOW_PAST_COUPONS_COUNT("new.app.test.backflow.past.coupons.count", "5000", "总发券量低于{}"),
    NAT_BACKFLOW_TODAY_COUPONS_COUNT("new.app.test.backflow.today.coupons.count", "1000", "媒体当日实时累计发券达"),
    NAT_BACKFLOW_BILLING_UP("new.app.test.backflow.billing.up", "2.00", "新媒体上计费上限"),

    // 新媒体测试-广告准入门槛
    NAT_ACCESS_ADVERT_PAST_DAYS("new.app.test.access.advert.past.days", "5", "广告连续前{}天"),
    NAT_ACCESS_ADVERT_CONSUME("new.app.test.access.advert.consume", "4000", "日消耗大于{}"),
    NAT_ACCESS_FIRST_ECHELON_CONSUME("new.app.test.access.first.echelon.consume", "50000", "第一梯队，广告配置前一日消耗大于等于"),

    // 新媒体测试-广告退出机制
    NAT_LAUNCH_MAX(SystemConfigKeyConstant.TUIA_NEW_APP_LAUNCH_MAX, "5000", "单广告单日在所有媒体上发券上限"),
    NAT_ADVERT_LIMIT_APP_SIZE(SystemConfigKeyConstant.NEW_APP_TEST_ADVERT_LIMIT_APP_SIZE, "4", "单广告计划同时在测媒体数量上限"),
    NAT_NOT_TEST_ORIENTATION(SystemConfigKeyConstant.TUIA_NEW_APP_NOT_TEST_ORIENTATION, "", "广告黑名单（不参与新媒体填充）"),
    NAT_ORIENTATION_APP_SIZE_KEY(SystemConfigKeyConstant.NEW_APP_TEST_ORIENTATION_APP_SIZE_KEY, "5", "新媒体过滤配置的定向媒体个数下限（不参与新媒体填充）"),
    NAT_EXIT_ADVERT_MIN("new.app.test.exit.advert.today.consume.min", "10", "单广告在新媒体投放消耗不小于广告当日总消耗的5%"),
    NAT_EXIT_FUSING_TIMES("new.app.test.exit.fusing.advert.cost.times", "5", "广告当日在新媒体转化0，但广告消耗不小于广告考核成本的5倍"),

    // 其他

    ;
    private final String key;
    private final String value;
    private final String desc;
}
