package cn.com.tuia.advert.enums;

import com.google.common.collect.Maps;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by MichealWang on 2018/10/29 0029.
 * 广告ocpc后端数据 调整因子
 */
public enum AdvertSubtypeEnum {
    /**
     * 落地页转化
     */
    CVR(0, "落地页转化"),
    /**
     * 安装
     */
    INSTALL(1, "安装"),
    /**
     * 启动
     */
    START(2, "激活(启动)"),
    /**
     * 注册
     */
    REGISTER(3, "注册"),
    /**
     * 激活
     */
    ACTIVITY(4, "激活"),
    /**
     * 登录
     */
    LOGIN(5, "登录"),
    /**
     * 付费
     */
    PAY(6, "付费"),
    /**
     * 进件
     */
    ENTRY(7, "进件"),
    /**
     * 完件
     */
    FINISH(8, "完件"),
    /**
     * 签收
     */
    SIGN_FOR(9, "签收"),
    /**
     * 留存
     */
    DENY(10, "留存"),

    /**
     * 出单
     */
    OUT_ORDER(11, "出单"),

    ORDER_CANCEL(12, "订单取消"),
    BUSI_AUDIT_NO(13, "商家审核不通过"),
    AUDIT_PASS(14, "审核通过"),
    CUST_AUDIT_NO(15, "客服审核不通过"),
    BUSI_CANCEL_SEND(16, "商家取消发货"),
    CUST_CANCEL_SEND(17, "客服取消发货"),
    ROBOT_CANCEL_SEND(18, "机器人取消发货"),

    LANDING_TIME_CONSUME(19, "落地页首页停留时长超过5s"),
    ;
    public static HashMap<Integer, AdvertSubtypeEnum> ADVERT_SUBTYPE_MAPPING = Maps.newHashMap();

    static {
        ADVERT_SUBTYPE_MAPPING.put(0, CVR);
        ADVERT_SUBTYPE_MAPPING.put(1, INSTALL);
        ADVERT_SUBTYPE_MAPPING.put(2, START);
        ADVERT_SUBTYPE_MAPPING.put(3, REGISTER);
        ADVERT_SUBTYPE_MAPPING.put(4, ACTIVITY);
        ADVERT_SUBTYPE_MAPPING.put(5, LOGIN);
        ADVERT_SUBTYPE_MAPPING.put(6, PAY);
        ADVERT_SUBTYPE_MAPPING.put(7, ENTRY);
        ADVERT_SUBTYPE_MAPPING.put(8, FINISH);
        ADVERT_SUBTYPE_MAPPING.put(9, SIGN_FOR);
        ADVERT_SUBTYPE_MAPPING.put(10, DENY);
        ADVERT_SUBTYPE_MAPPING.put(11, OUT_ORDER);
        ADVERT_SUBTYPE_MAPPING.put(12, ORDER_CANCEL);
        ADVERT_SUBTYPE_MAPPING.put(13, BUSI_AUDIT_NO);
        ADVERT_SUBTYPE_MAPPING.put(14, AUDIT_PASS);
        ADVERT_SUBTYPE_MAPPING.put(15, CUST_AUDIT_NO);
        ADVERT_SUBTYPE_MAPPING.put(16, BUSI_CANCEL_SEND);
        ADVERT_SUBTYPE_MAPPING.put(17, CUST_CANCEL_SEND);
        ADVERT_SUBTYPE_MAPPING.put(18, ROBOT_CANCEL_SEND);
    }

    private Integer subtype;

    private String desc;

    public Integer getSubtype() {
        return subtype;
    }

    public void setSubtype(Integer subtype) {
        this.subtype = subtype;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    AdvertSubtypeEnum(Integer subtype, String desc) {
        this.subtype = subtype;
        this.desc = desc;
    }

    public static AdvertSubtypeEnum getSubtypeEnumBySubtype(Integer subtype) {
        return ADVERT_SUBTYPE_MAPPING.get(subtype);
    }

    private static Map<Integer, AdvertSubtypeEnum> enumMap = Maps.newHashMap();

    static {
        for (AdvertSubtypeEnum it : AdvertSubtypeEnum.values()) {
            enumMap.put(it.getSubtype(), it);
        }
    }

    public static AdvertSubtypeEnum getBySubtype(Integer subtype) {
        return enumMap.get(subtype);
    }

}
