package cn.com.tuia.advert.enums;

/**
 * 考核指标，映射优化目标，注::仅仅用于广告CPC计费模式且无开启自动竞价
 */
public enum AssessTypeMapSubTypeEnum {

    start(6, 2),

    REGISTER(7, 3),
    ;

    //cvrType-落地页
    private static Integer LOAD_PAGE = 0;

    AssessTypeMapSubTypeEnum(Integer assessType, Integer subType) {
        this.assessType = assessType;
        this.subType = subType;
    }

    //通过考核指标，获取对应的优化目标type,
    public static Integer getSubTypeByAssessType(Integer assessType){

        for(AssessTypeMapSubTypeEnum typeEnum : AssessTypeMapSubTypeEnum.values()){

            if(typeEnum.getAssessType().equals(assessType)){
                return typeEnum.getSubType();
            }
        }

        //默认为0;
        return LOAD_PAGE;
    }

    //考核指标
    private Integer assessType;

    //优化目标
    private Integer subType;

    public Integer getAssessType() {
        return assessType;
    }

    public Integer getSubType() {
        return subType;
    }

}
